/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 25Jul2000:	ACR	First version - tested on Linux only.		*/
/* 14Aug2000:	ACR	Improvements to add_alias.			*/
/* 20Apr2001:	ACR	Changed negative return codes to x1 return	*/
/*			 codes, thus -4 becomes 14, -5 15 etc.		*/
/*			Accordingly, tests of return codes change, so	*/
/*			    if (func(arg) < 0)				*/
/*			becomes,					*/
/*			    if (func(arg) > 10)				*/
/* 08May2001:	ACR	Started using Dan's strerr_warn etc. calls.	*/
/************************************************************************/
/* To do:	Standardise return codes.				*/
/************************************************************************/

#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "fmt.h"
#include "str.h"
#include "strerr.h"
#include "stralloc.h"
#include "substdio.h"
#include "subfd.h"
#include "error.h"

#include "hash_core.h"
#include "admin_core.h"
#include "noddylib.h"

/* chdir_or_mkdir... tries to change to a directory, or failing that,	*/
/* creates it and then changes into it. In the former case it returns	*/
/* 0, in the latter 1. Otherwise a return of 11 indicates an error.	*/

int chdir_or_mkdir700_and_chdir(char *dir)
{
  mode_t um;
  if (chdir(dir) < 0)
    if (errno==ENOENT) /* Only want to create dir if it doesn't exist */
    {
      um=umask(0077);
      if ((mkdir(dir,0700) < 0) || (chdir(dir) < 0))
      {
        strerr_warn1("Error when trying to mkdir/chdir: ",&strerr_sys);
        umask(um);
        return(11);
      };

      umask(um);
      return(1);
    }
    else			/* Non-ENOENT problem with chdir	*/
    {
      strerr_warn1("Unexpected error: ",&strerr_sys);
      return(11);
    };
  return(0);					/* Dir already exists	*/
}

/* this function adds any hash directories that don't already exist,	*/
/* and chdirs into them.						*/
int add_hashdirs_and_chdir(char *user)
{
  char h1[MAX_H1_LEN], h2[MAX_H2_LEN], h3[MAX_H3_LEN];

  gen_string_hashes(user,h1,h2,h3);
  if (  (chdir_or_mkdir700_and_chdir(h1) > 10)
     || (chdir_or_mkdir700_and_chdir(h2) > 10)
     || (chdir_or_mkdir700_and_chdir(h3) > 10) )
    return(11);
  else
    return(0);
};

int add_user(char *u)
{
  int res;
  struct stat st;

  if (stat(maildirs_basedir,&st) < 0)
  {
    strerr_warn3("Error: ",maildirs_basedir,": ", &strerr_sys);
    substdio_flush(subfderr);
    return(11);
  };
  if (st.st_uid != geteuid())
  {
    strerr_warn4("Error: Ownership of ",maildirs_basedir," is wrong, or",
                 " you're running this program as the wrong user.",0);
    return(11);
  };
  if (chdir(maildirs_basedir) < 0)
  {
    strerr_warn3("Error entering ",maildirs_basedir,": ",&strerr_sys);
    return(12);
  };
  if (add_hashdirs_and_chdir(u) > 10) return(11);
  if ( res=chdir_or_mkdir700_and_chdir(u), res > 10  )
  {
    strerr_warn1("Couldn't make actual user dir",0);
    return(13);
  };
  if ( res==0 )
  {
    strerr_warn1("Error: User dir already exists.",0);
    return(14);
  }
  else
    return(0);						/* Success	*/
}

int add_to_aliaslist(char *a)
{ /* Thinks: May prefer to have hashdir_a as a parameter too, since this
     is known when this function is called */
  char hashdir_a[MAX_HASHDIR_LEN];
  char *p;
  int res;
  struct stat st,lst;

  get_hashdir(a,hashdir_a);
  if (chdir(hashdir_a) < 0)
  {
    strerr_warn2("Error: Couldn't enter directory for ",a,0);
    return(12);
  };
  if (chdir_or_mkdir700_and_chdir(ALIAS_LIST) > 10)
    return(11); /* Error message already given by fn. */
  /* Don't need fd returned by open: File must merely exist */
  if (open(a,O_WRONLY | O_EXCL | O_CREAT,0400) < 0)
  {
    strerr_warn1("Error: Unexpected problem updating the aliases list.",0);
    return(12);
  };
  return(0);	/* Success: symlink & alias list entry added	*/
		/* NB a automatically closed on program exit	*/
};

int add_alias(char *u, char *a)
{
  stralloc hashdir_u_sa = {0}, hashdir_a_sa = {0}, syml_sa = {0};
  int res;
  struct stat st,lst;

  if (stat(maildirs_basedir,&st) < 0)
  {
    strerr_warn3("Error: ",maildirs_basedir,": ",&strerr_sys);
    return(11);
  };
  if (st.st_uid != geteuid())
  {
    strerr_warn4("Error: Ownership of ",maildirs_basedir," is wrong,",
                 " or you're running this program as the wrong user.",0);
    return(11);
  };

  add_hashdir_sa(u,&hashdir_u_sa);
  add_hashdir_sa(a,&hashdir_a_sa);

  if (chdir(hashdir_u_sa.s) < 0)
  {
    strerr_warn1("Error: User not setup.",0);
    return(12);
  };
  if (chdir(hashdir_a_sa.s) == 0)
  {
    strerr_warn1("Error: Alias/username already in use.",0);
    return(12);
  };
  if (lstat(hashdir_u_sa.s,&lst) < 0)
  {
    strerr_warn1("Error: Unexpected problem with username.",0);
    return(12);
  };
  if (S_ISLNK(lst.st_mode))
  {
    strerr_warn1("Error: Username given is actually an alias.",0);
    return(12);
  };
  if (chdir(maildirs_basedir) < 0)
  {
    strerr_warn3("Error entering ",maildirs_basedir,": ",&strerr_sys);
    return(12);
  };
  if (add_hashdirs_and_chdir(a) > 10) return(11);
  if (!stralloc_cats(&syml_sa,"../../../")) die_nomem111();
  add_hash_sa(u,&syml_sa);	/* ../../../h1/h2/h3/username */
  if ( symlink(syml_sa.s,hashdir_a_sa.s) < 0 )
  {
    strerr_warn1("Error: Couldn't make alias: ",&strerr_sys);
    return(13);
  };
  return(add_to_aliaslist(a));
}
