/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 08Aug2000:	ACR	First version - tested on Linux only.		*/
/************************************************************************/

#include "stralloc.h"
#include "hash_core.h"
#include "admin_core.h"
#include "noddylib.h"
#include "subfd.h"
#include "strerr.h"

int main( int argc, char *argv[] )
{
  if ( argc != 3)
  {
    strerr_warn3("Error: Wrong no. of arguments.\n       Usage: ", \
                                    argv[0]," <username> <alias_to_add>",0);
    return(1);
  }
  else
  {
    stringclean(argv[1]);
    stringclean(argv[2]);
    if (not_hashable(argv[1]) || not_hashable(argv[2]))
    {
      strerr_warn1(
       "Error: Malformed username/alias given (invalid chars or too long).",0);
      return(1);
    }
    else
      return(add_alias(argv[1],argv[2]));
  }
}
