/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000 except Stevens extracts	*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 11Jul2000:	ACR	First version - tested on Linux only.		*/
/* 24Jul2000:	ACR	Various tweaks. convertpopstring moved here.	*/
/* 07Aug2000:	ACR	Use DJB case_lowers instead of my decapitalise.	*/
/* 			Use DJB str_len instead of strlen.		*/
/************************************************************************/
/* Notes:	unistd.h only needed here for definition of NULL!	*/
/************************************************************************/

#include <unistd.h>
#include "../qmail-1.03/case.h"
#include "../qmail-1.03/str.h"

/* This function a 'Lite' version of isspace that doesn't handle EOF	*/
int ch_is_space(char c)
{
/* This version for small executables (untested)
  return(((c=='\t')||(c=='\n')||(c=='\v')||(c=='\f')||(c=='\r')||(c==' '))?1:0)
*/
  switch (c) /* this version for speed */
  {
    case '\t': case '\n': case '\v': case '\f': case '\r': case ' ': return(1);
    default: return(0);
  }
}

void tidystringtail(char *str)
{
  char *str_end;
  str_end = str + str_len(str) - 1;
  while (str_end >= str && ch_is_space(*str_end)) *str_end-- = '\0';
}

/* In some mail clients, can't give "x@y" as username, must give "x%y" */
void convertpopstring(char *popstring)
{
  while (*popstring)
  {
    if (*popstring == '%') *popstring = '@';
    popstring++;
  }
}

/* returns the pointer to "@domain" from "user@domain", or NULL */
char *stripusername(char *s)
{
  while (*s)
  {
    if (*s == '@') return(s);
    s++;
  };
  return(NULL);
}

void stringclean(char *str)
{
  tidystringtail(str);
  case_lowers(str);
  convertpopstring(str);
}

/* This function checks that all characters in s appear in v. Can also	*/
/* be coded with <string.h> as (strspn(s,HASHABLE_CH) != str_len(s))	*/
int str_checkchars(char *s,char *validchars)
{
  char *v;

  while (*s)
  {
    v = validchars;
    while (*v)			/* Scan v for *s */
    {
      if (*v==*s) break;
      v++;
    };
    if (!*v) return(0);		/* Reached end of v without finding *s */
    s++;
  };
  return(1);			/* All chars were in v */
}
