/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 11Jul2000:	ACR	First version - tested on Linux only.		*/
/* 07Aug2000:	ACR	Updated to use DJB libraries instead of		*/
/*			standard Unix. Likely to be preferable to	*/
/*			qmail community.				*/
/************************************************************************/
/* Description:	This program is designed to be called as part of the	*/
/*		qmail delivery process by qmail-local. It typically	*/
/*		lives in a .qmail file relating to single-UID delivery	*/
/*		where it is called as a program delivery to generate	*/
/*		the relevant hash dir, which it then uses to call	*/
/*		qmail-local. As part of the process, this program sees	*/
/*		if it can chdir to the relevant hash dir. If it doesn't	*/
/*		even get close, it assumes that the hashed directory	*/
/*		(probably on shared storage) is not available, so	*/
/*		returns 111, a temporary error, which will defer the	*/
/*		delivery. If it can't chdir to the specific directory,	*/
/*		this means that the user doesn't exist, so then strip	*/
/*		off the username and try to hash just '@domain' as a	*/
/*		catch-all mailbox. Failing this, return 100 and		*/
/*		"Unknown user" on stderr. 100 is a permanent error so	*/
/*		the delivery is aborted.				*/
/************************************************************************/
/* Side effects:qmail-local and arguments are given as arguments to	*/
/*		this function. These arguments are modified, however -	*/
/*		homedir becomes the hash directory.			*/
/************************************************************************/
/* Assumptions:	The system assumes that the system in use has a well	*/
/*		populated hashed directory structure, so that all the	*/
/*		possible 1st level hashes do exist. This is used by the	*/
/*		unreachable_mailbox function to choose between a temp	*/
/*		or permanent error. The former is for the situation	*/
/*		where the hashed directory structure is on shared	*/
/*		(NFS?) storage but has become unmounted/unreachable.	*/
/*		This prevents mail being bounced in this situation.	*/
/*		If each 1st level hash is a mount-point, adjust this fn	*/
/************************************************************************/

#include <unistd.h>
#include "hash_core.h"
#include "noddylib.h"
#include "../qmail-1.03/subfd.h"

int call_qmail_local(char *hashdir,char **newargv)
{
  newargv[2]=hashdir;			/* $HOMEDIR for qmail-local	*/
  execvp(newargv[0],newargv);

  substdio_puts(subfderr,"Couldn't start ");
  substdio_puts(subfderr,newargv[0]);
  substdio_puts(subfderr,"\n");
  substdio_flush(subfderr);

  return(111);			/* Couldn't exec, so temporary error	*/
};

int unreachable_mailbox(char *username)
{
  char h1[MAX_H1_LEN], h2[MAX_H2_LEN], h3[MAX_H3_LEN];

  gen_string_hashes(username,h1,h2,h3);

  if ((chdir(maildirs_basedir)<0) || (chdir(h1)<0))
  {		/* add || (chdir(h2)<0) if h1 dirs are mount-points	*/
    substdio_puts(subfderr,"Error: Mailbox temporarily unavailable\n");
    substdio_flush(subfderr);
    return(111);	/* Couldn't reach h1 suggests mount problems	*/
  };

  substdio_puts(subfderr,"Error: Unknown user\n");
  substdio_flush(subfderr);
  return(100);
}

int main( int argc, char *argv[] )
{
  char h[MAX_HASHDIR_LEN];
  char *at_domain;

  if ( argc != 11)
  {
    substdio_puts(subfderr,"Error: Wrong no. arguments;\n   usage: ");
    substdio_puts(subfderr,argv[0]);
    substdio_puts(subfderr," <name> <qmail-local and args>\n");
    substdio_flush(subfderr);
    return(2);
  };

  stringclean(argv[1]);
  if (not_hashable(argv[1]))
  {
    substdio_puts(subfderr,"Error: Malformed mailbox name.\n");
    substdio_flush(subfderr);
    return(100);
  };

  get_hashdir(argv[1],h);
  if (chdir(h)==0)					/* User exists	*/
    return(call_qmail_local(h,argv+2));

  if ((at_domain=stripusername(argv[1])) != NULL)
  {
    get_hashdir(at_domain,h);
    if (chdir(h)==0)			/* Catch-all @domain exists	*/
      return(call_qmail_local(h,argv+2));
  };

  return(unreachable_mailbox(argv[1]));

}
