/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000			 	*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* Notes on implementation: This module uses the ubiquitous hashpjw	*/
/* function. There's no reason why you shouldn't use any other function	*/
/* of your choice - DJ Bernstein, Phong Vo, Chris Torek, Thinking	*/
/* Machines all have hash functions available, or you could go for	*/
/* something simple (with a tradeoff on performance) such as a		*/
/* multiplication hash - like h=h*7+*s - but remember to consider	*/
/* portability (overflowing an int - int sizes vary)			*/
/************************************************************************/

/* Note: Prime numbers chosen for hashes - this may improve performance	*/
#define HASH1 19
#define HASH2 199
#define HASH3 199

/* For hash calculations, we need a 4 byte int. Adjust for your system	*/
typedef unsigned int u4int;

/* All _LEN  definitions include 1 for a string terminating '\0'	*/
/* A hash of 100 will give "0" to "99", i.e. 2 characters plus a null,	*/
/* making 3 in all.							*/
#define MAX_H1_LEN   3
#define MAX_H2_LEN   4
#define MAX_H3_LEN   4
#define maildirs_basedir "/maildirs"
#define BASEDIR_LEN 10
#define MAX_HASHABLE_LEN 100
#define MAX_HASH_LEN     (MAX_H1_LEN+MAX_H2_LEN+MAX_H3_LEN)
#define MAX_HASHDIR_LEN  (BASEDIR_LEN+MAX_HASH_LEN+MAX_HASHABLE_LEN)
/* Be *very* careful if you increase HASHABLE_CHaracters (shell escapes,
   filename issues) */
#define HASHABLE_CH      "abcdefghijklmnopqrstuvwxyz1234567890-.@_+"

int   not_hashable(char *s);
u4int gen_hash(char *s);
void  print_hashdir(char *s);
void  gen_string_hashes(char *s, char *s_h1, char *s_h2, char *s_h3);
void  get_hashes_str(char *s, char *hashs);
void  get_hashdir(char *s, char *hashd);
