/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 25Jul2000:	ACR	First version - tested on Linux only.		*/
/* 14Aug2000:	ACR	Improvements to add_alias.			*/
/************************************************************************/
/* To do:	Standardise return codes.				*/
/************************************************************************/

#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "hash_core.h"
#include "admin_core.h"
#include "noddylib.h"
#include "../qmail-1.03/fmt.h"
#include "../qmail-1.03/str.h"
#include "../qmail-1.03/substdio.h"
#include "../qmail-1.03/subfd.h"
#include "../qmail-1.03/error.h"

/* chdir_or_mkdir... tries to change to a directory, or failing that,	*/
/* creates it and then changes into it. In the former case it returns	*/
/* 0, in the latter 1. Otherwise a return of -1 indicates an error.	*/

int chdir_or_mkdir700_and_chdir(char *dir)
{
  mode_t um;
  if (chdir(dir) < 0)
    if (errno==ENOENT) /* Only want to create dir if it doesn't exist */
    {
      um=umask(0077);
      if ((mkdir(dir,0700) < 0) || (chdir(dir) < 0))
      {
        substdio_puts(subfderr,"Error when trying to mkdir/chdir: ");
        substdio_puts(subfderr,error_str(errno));
        substdio_puts(subfderr,"\n");
        substdio_flush(subfderr);
        umask(um); return(-1);
      };

      umask(um);
      return(1);
    }
    else			/* Non-ENOENT problem with chdir	*/
    {
      substdio_puts(subfderr,"Unexpected error: ");
      substdio_puts(subfderr,error_str(errno));
      substdio_puts(subfderr,"\n");
      substdio_flush(subfderr);
      return(-1);
    };
  return(0);					/* Dir already exists	*/
}

/* this function adds any hash directories that don't already exist,	*/
/* and chdirs into them.						*/
int add_hashdirs_and_chdir(char *user)
{
  char h1[MAX_H1_LEN], h2[MAX_H2_LEN], h3[MAX_H3_LEN];

  gen_string_hashes(user,h1,h2,h3);
  if (  (chdir_or_mkdir700_and_chdir(h1) < 0)
     || (chdir_or_mkdir700_and_chdir(h2) < 0)
     || (chdir_or_mkdir700_and_chdir(h3) < 0) )
    return(-1);
  else
    return(0);
};

int add_user(char *u)
{
  int res;
  struct stat st;

  if (stat(maildirs_basedir,&st) < 0)
  {
    substdio_puts(subfderr,"Error: ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr,": ");
    substdio_puts(subfderr,error_str(errno));
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-1);
  };
  if (st.st_uid != geteuid())
  {
    substdio_puts(subfderr,"Error: Ownership of ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr," is wrong.\n");
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-1);
  };
  if (chdir(maildirs_basedir) < 0)
  {
    substdio_puts(subfderr,"Error entering ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr,": ");
    substdio_puts(subfderr,error_str(errno));
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (add_hashdirs_and_chdir(u) < 0) return(-1);
  if ( res=chdir_or_mkdir700_and_chdir(u), res < 0  )
  {
    substdio_puts(subfderr,"Couldn't make actual user dir\n");
    substdio_flush(subfderr);
    return(-3);
  };
  if ( res==0 )
  {
    substdio_puts(subfderr,"Error: User dir already exists.\n");
    substdio_flush(subfderr);
    return(-4);
  }
  else
    return(0);						/* Success	*/
}

int add_to_aliaslist(char *a)
{
  char hashdir_a[MAX_HASHDIR_LEN];
  char *p;
  int res;
  struct stat st,lst;

  get_hashdir(a,hashdir_a);
  if (chdir(hashdir_a) < 0)
  {
    substdio_puts(subfderr,"Error: Couldn't enter directory for ");
    substdio_puts(subfderr,a);
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (chdir_or_mkdir700_and_chdir(ALIAS_LIST) < 0)
    return(-1); /* Error message already given by fn. */
  /* Don't need fd returned by open: File must merely exist */
  if (open(a,O_WRONLY | O_EXCL | O_CREAT,0400) < 0)
  {
    substdio_puts(subfderr,"Error: Unexpected problem updating the aliases list.\n");
    substdio_flush(subfderr);
    return(-2);
  };
  return(0);	/* Success: symlink & alias list entry added	*/
		/* NB a automatically closed on program exit	*/
};

int add_alias(char *u, char *a)
{
  char hashdir_u[MAX_HASHDIR_LEN], hashdir_a[MAX_HASHDIR_LEN],
       syml[MAX_HASH_LEN+9+MAX_HASHABLE_LEN]; /* ../../../h1/h2/h3/username */
  char *p;
  int res;
  struct stat st,lst;

  if (stat(maildirs_basedir,&st) < 0)
  {
    substdio_puts(subfderr,"Error: ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr,": ");
    substdio_puts(subfderr,error_str(errno));
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-1);
  };
  if (st.st_uid != geteuid())
  {
    substdio_puts(subfderr,"Error: Ownership of ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr," is wrong.\n");
    substdio_flush(subfderr);
    return(-1);
  };
  get_hashdir(u,hashdir_u);
  get_hashdir(a,hashdir_a);

  if (chdir(hashdir_u) < 0)
  {
    substdio_puts(subfderr,"Error: User not setup.\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (chdir(hashdir_a) == 0)
  {
    substdio_puts(subfderr,"Error: Alias/username already in use.\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (lstat(hashdir_u,&lst) < 0)
  {
    substdio_puts(subfderr,"Error: Unexpected problem with username.\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (S_ISLNK(lst.st_mode))
  {
    substdio_puts(subfderr,"Error: Username given is actually an alias.\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (chdir(maildirs_basedir) < 0)
  {
    substdio_puts(subfderr,"Error entering ");
    substdio_puts(subfderr,maildirs_basedir);
    substdio_puts(subfderr,": ");
    substdio_puts(subfderr,error_str(errno));
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-2);
  };
  if (add_hashdirs_and_chdir(a) < 0) return(-1);
  p=syml+fmt_str(syml,"../../../"); *p='\0';
  get_hashes_str(u,p); /* adds hashes after "/" */
  if ( symlink(syml,hashdir_a) < 0 )
  {
    substdio_puts(subfderr,"Error: Couldn't make alias: ");
    substdio_puts(subfderr,error_str(errno));
    substdio_puts(subfderr,"\n");
    substdio_flush(subfderr);
    return(-3);
  };
  return(add_to_aliaslist(a));
}
