/*
** Andrew Richards <andrew@tic.ch>: Attempt to have a Courier
** version of checkpassword. Standard checkpassword and Courier's
** authtest used as the source material.
**
** Version info:
**   21Nov2001 ACR 0.10 First version.
**
** Notes:
**  ==>	You generally need to run this program as root in order
**	for Courier to access authentication data.
**  ==>	I've not made a serious attempt to DJB-ise this program,
**	since Courier is built on stdio and friends, so eliminating
**	it here is unlikely to make a significant difference to
**	the code size or security. Also note that the checkpassword
**	base is not the most recent.
**  ==>	Refer to my homepage for the most recent version of this
**	program,
**		http://www.tic.ch/e-image/andrew/
**  ==>	I'm not familiar enough with Courier to know whether this
**	approach to authentication has any significant security
**	issues. You should satisfy yourself about the security or
**	otherwise of this program before using it.
**  ==>	When Courier successfully authenticates a user, it will
**	setuid and setgid to that user (if the prog was started
**	as root, anyway), thus no prot_xid(), chdir() calls as
**	in std checkpassword.
**  ==>	HOME and SHELL get set to "" by this program; for HOME,
**	the Courier approach seems to be to use getcwd to work
**	out 'where am I' - I've not implemented that. For SHELL,
**	I'm not sure whether that can be determined [for all
**	authentication methods].
**  ==>	I've developed this against Courier-IMAP version 1.3.12;
**	with other versions, your mileage may vary.
**
** Status / Warranty:
** This software should be regarded as 'Alpha-release' software,
** and is therefore inappropriate for production use without
** extensive testing. No warranty, express or implied is given
**  - USE THIS SOFTWARE ENTIRELY AT YOUR OWN RISK.
**
** License: Unsure: Courier is GPL, checkpassword from Dan. This
** program has a little from Courier, lots from checkpassword, so
** consider this program to be under Dan Bernstein's licensing
** conditions.
*/

/* From authtest */
#include        "auth.h"
#include        "authmod.h"
#include        "authstaticlist.h"
#include        <stdlib.h>
#include        <string.h>
#include        <errno.h>
#if     HAVE_UNISTD_H
#include        <unistd.h>
#endif

/* From std checkpassword: */
extern char **environ;
char up[513];
int uplen;

char *str1e2(name,value) char *name; char *value;
{
  char *nv;
  nv = malloc(strlen(name) + strlen(value) + 2);
  if (!nv) _exit(111);
  strcpy(nv,name);
  strcat(nv,"=");
  strcat(nv,value);
  return nv;
}

int main(int argc, char **argv)
{
  char *login;
  char *password;
  char *login_eos, *password_eos;
  int r;
  int i;
  char **newenv;
  int numenv;
  char *p;

  if (!argv[1]) _exit(2);

  uplen = 0;
  for (;;) {
    do
      r = read(3,up + uplen,sizeof(up) - uplen);
    while ((r == -1) && (errno == EINTR));
    if (r == -1) _exit(111);
    if (r == 0) break;
    uplen += r;
    if (uplen >= sizeof(up)) _exit(1);
  }

  close(3);

  i = 0;
  login = up + i;
  while (up[i++]) if (i == uplen) _exit(2);
  login_eos = up + i - 1;
  password = up + i;
  if (i == uplen) _exit(2);
  while (up[i++]) if (i == uplen) _exit(2);
  password_eos = up + i - 1;

  /* login, password delimited by '\n' for Courier auth call */
  *login_eos = '\n'; *password_eos = '\n';

  for (i=0; authstaticmodulelist[i]; i++)
  {
    /* Authentication happens here: */
    p= (*authstaticmodulelist[i]->auth_func)("login", AUTHTYPE_LOGIN, up, 0, 0, 0);

    if (p == 0) /* Failed auth, I presume */
    {
      if (errno != EPERM)
        _exit(111);
      continue; /* Try next auth method instead */
    }

    /* Clear password from prying eyes: */
    for (i = (int)(password-up);i < sizeof(up);++i) up[i] = 0;
    *login_eos = '\0'; /* Previously set to '\n' for Courier's benefit */
 
    numenv = 0;
    while (environ[numenv]) ++numenv;
    newenv = (char **) malloc((numenv + 4) * sizeof(char *));
    if (!newenv) _exit(111);
    for (i = 0;i < numenv;++i) newenv[i] = environ[i];
    newenv[numenv++] = str1e2("USER",login);
    newenv[numenv++] = str1e2("HOME","");  /* Don't know how to get this from Courier */
    newenv[numenv++] = str1e2("SHELL",""); /* Ditto */
    newenv[numenv] = 0;
    environ = newenv;
   
    execvp(argv[1],argv + 1);
    _exit(111);
  }
  _exit(1); /* Fail: Ran out of auth methods */
}
